"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const helpers_js_1 = require("../utils/helpers.js");
const rule = {
    meta: {
        type: 'problem',
        docs: {
            description: 'Disallow browser.debug() in tests',
            category: 'Possible Errors',
            url: 'https://github.com/webdriverio/webdriverio/blob/main/packages/eslint-plugin-wdio/docs/rules/no-debug.md',
            recommended: false,
        },
        messages: {
            unexpectedDebug: 'Unexpected browser.debug() not allowed'
        },
        hasSuggestions: true,
        schema: [],
    },
    create: function (context) {
        return {
            CallExpression(node) {
                if ((0, helpers_js_1.isCommand)(node, 'debug')) {
                    context.report({ node, messageId: 'unexpectedDebug' });
                }
            }
        };
    }
};
exports.default = rule;
