"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const constants_js_1 = require("../constants.js");
const rule = {
    meta: {
        type: 'problem',
        docs: {
            description: 'expect must be prefixed with await',
            category: 'Possible Errors',
            url: 'https://github.com/webdriverio/webdriverio/blob/main/packages/eslint-plugin-wdio/docs/rules/await-expect.md',
            recommended: false,
        },
        messages: {
            missingAwait: 'Missing await before an expect statement'
        },
        hasSuggestions: true
    },
    create: function (context) {
        return {
            CallExpression(node) {
                /**
                 * validate we have an expect statement that
                 * calls some of the WebdriverIO matchers
                 */
                if (node.callee.type !== 'MemberExpression' ||
                    node.callee.object.type !== 'CallExpression' ||
                    node.callee.object.callee.name !== 'expect' ||
                    !constants_js_1.MATCHERS.includes(node.callee.property.name)) {
                    return;
                }
                /**
                 * fail rule if:
                 */
                if (
                /**
                 * expect is called without an `await` and as part of an
                 * expression
                 */
                node.parent.type === 'ExpressionStatement') {
                    context.report({ node, messageId: 'missingAwait' });
                }
            }
        };
    }
};
exports.default = rule;
