"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
const await_expect_js_1 = __importDefault(require("./rules/await-expect.js"));
const no_debug_js_1 = __importDefault(require("./rules/no-debug.js"));
const no_pause_js_1 = __importDefault(require("./rules/no-pause.js"));
const sharedGlobals = {
    $: false,
    $$: false,
    browser: false,
    driver: false,
    expect: false,
    multiremotebrowser: false,
};
const sharedConfig = {
    rules: {
        'wdio/await-expect': 'error',
        'wdio/no-debug': 'error',
        'wdio/no-pause': 'error',
    },
};
const index = {
    configs: {},
    rules: {
        'await-expect': await_expect_js_1.default,
        'no-debug': no_debug_js_1.default,
        'no-pause': no_pause_js_1.default,
    },
};
const legacyConfig = {
    ...sharedConfig,
    globals: sharedGlobals,
    plugins: ['wdio'],
};
const flatConfig = {
    ...sharedConfig,
    languageOptions: {
        globals: sharedGlobals,
    },
    plugins: {
        wdio: index,
    },
};
module.exports = {
    ...index,
    configs: {
        'flat/recommended': flatConfig,
        recommended: legacyConfig,
    },
};
