/**
 * @fileoverview Forbids use of QUnit.reset.
 * @author Kevin Partington
 * @copyright 2016 Kevin Partington. All rights reserved.
 * See LICENSE file in root directory for full license.
 */
"use strict";
//------------------------------------------------------------------------------
// Rule Definition
//------------------------------------------------------------------------------
/** @type {import('eslint').Rule.RuleModule} */
module.exports = {
    meta: {
        type: "suggestion",
        docs: {
            description: "disallow QUnit.reset",
            category: "Best Practices",
            url: "https://github.com/platinumazure/eslint-plugin-qunit/blob/main/docs/rules/no-reset.md",
        },
        messages: {
            noReset: "Do not use QUnit.reset().",
        },
        schema: [],
    },
    create: function (context) {
        //--------------------------------------------------------------------------
        // Public
        //--------------------------------------------------------------------------
        return {
            "CallExpression[callee.object.name='QUnit'][callee.property.name='reset']": 
            /**
             * @param {import('eslint').Rule.Node} node
             */
            function (node) {
                context.report({
                    node: node,
                    messageId: "noReset",
                });
            },
        };
    },
};
