const MODE_CHARS = [ '@', '+' ];
const CHANNEL_TYPE_CHANNEL = 'channel';

class StatusmsgPlugin {
	constructor( api ) {
		this.api = api;
	}

	doMessage( client, target, command, args ) {
		if ( target.chan.type !== CHANNEL_TYPE_CHANNEL ) {
			client.sendMessage(
				`/${ command } can only be used in channels`,
				target.chan
			);

			return;
		}

		client.runAsUser(
			`/msg ${ command }${ target.chan.name } ${ args.join( ' ' ) }`,
			target.chan.id
		);
	}

	doMe( client, target, command, args ) {
		if ( target.chan.type !== CHANNEL_TYPE_CHANNEL ) {
			client.sendMessage(
				`/${ command } can only be used in channels`,
				target.chan
			);

			return;
		}

		const mode = command[ 0 ];
		target.network.irc.action(
			`${ mode }${ target.chan.name }`,
			args.join( ' ' )
		);
	}
}

module.exports = {
	onServerStart( thelounge ) {
		const plugin = new StatusmsgPlugin( thelounge );

		for ( const char of MODE_CHARS ) {
			thelounge.Commands.add(
				char,
				{
					input: plugin.doMessage,
					allowDisconnected: false
				}
			);

			thelounge.Commands.add(
				`${ char }me`,
				{
					input: plugin.doMe,
					allowDisconnected: false
				}
			);
		}
	}
};
