package ns

import (
	"testing"
)

func TestRemoveFirstPart(t *testing.T) {
	t.Parallel()

	addrs := []struct {
		name     string
		expected string
	}{
		{"majava.org.", "org."},
		{"255.255.255.255.in-addr.arpa.", "255.255.255.in-addr.arpa."},
		{".", "."},
	}
	for _, testCase := range addrs {
		t.Run(testCase.name, func(t *testing.T) {
			actual := removeFirstPart(testCase.name)
			if actual != testCase.expected {
				t.Errorf("For %v, wanted %v but got %v", testCase.name, testCase.expected, actual)
			}
		})
	}
}
