package ns

import (
	"errors"
	"fmt"
	"log/slog"
	"math/rand"
	"strings"

	"github.com/miekg/dns"

	"git.majava.org/software/edif/config"
)

func removeFirstPart(name string) string {
	if name == "." {
		return name
	}

	parts := strings.Split(name, ".")
	return strings.Join(parts[1:], ".")
}

func (q *Querier) getParentNameserver(zone config.Zone) (string, error) {
	// TODO: perhaps cache this
	name := dns.Fqdn(zone.Name)
	for name != "." {
		name = removeFirstPart(name)

		msg := &dns.Msg{}
		msg.SetQuestion(name, dns.TypeNS)
		msg.RecursionDesired = true

		r, _, err := q.c.Exchange(msg, q.recursor)
		if err != nil {
			return "", err
		}
		if r.Rcode != dns.RcodeSuccess {
			return "", fmt.Errorf("unexpected return code %v", dns.RcodeToString[r.Rcode])
		}

		for i := range r.Answer {
			j := rand.Intn(i + 1)
			r.Answer[i], r.Answer[j] = r.Answer[j], r.Answer[i]
		}
		for _, rr := range r.Answer {
			record, ok := rr.(*dns.NS)
			if !ok {
				slog.Warn("failed to parse answer to an NS record",
					"zone", zone.Name, "record", rr)
				continue
			}

			ns, _ := strings.CutSuffix(record.Ns, ".")
			return ns, nil
		}
	}

	return "", errors.New("found no results")
}
