package config

import (
	"os"

	"git.sr.ht/~emersion/go-scfg"
)

type Nameserver struct {
	Hostname string `scfg:",param"`
}

type Zone struct {
	Name         string       `scfg:",param"`
	Nameservers  []Nameserver `scfg:"nameserver"`
	NoDelegation bool         `scfg:"no-delegation"`
}

type Config struct {
	Zones    []Zone `scfg:"zone"`
	ListenOn string `scfg:"listen-on"`
	Recursor string `scfg:"recursor"`
}

func Load(file string) (*Config, error) {
	f, err := os.Open(file)
	if err != nil {
		return nil, err
	}
	defer f.Close()

	config := Config{}
	if err := scfg.NewDecoder(f).Decode(&config); err != nil {
		return nil, err
	}

	return &config, nil
}
