from pathlib import Path

from dnsdeploy.dnssec import (
    get_expiry,
    get_signature_file,
    get_key_glob,
    Algorithm,
)


def test_get_expiry():
    fixture_path = Path(__file__).parent / "fixtures" / "dnssec"
    assert (
        get_expiry(
            fixture_path / "zones" / "whyisbetabroken.com.zone.signed",
            origin="whyisbetabroken.com.",
        )
        == 1761404755
    )

    assert (
        get_expiry(
            fixture_path / "zones" / "whyisbetabroken.com.zone",
            origin="whyisbetabroken.com.",
        )
        is None
    )


def test_get_signature_file():
    fixture_path = Path(__file__).parent / "fixtures" / "dnssec"
    assert (
        get_signature_file(fixture_path / "zones" / "whyisbetabroken.com.zone")
        == fixture_path / "zones" / "whyisbetabroken.com.zone.signed"
    )


def test_get_key_glob():
    assert get_key_glob(zone_name="example", algorithm=None) == "Kexample.*.key"
    assert (
        get_key_glob(zone_name="example.", algorithm=Algorithm.ED25519)
        == "Kexample.+015+*.key"
    )
