from pathlib import Path

from dnsdeploy.zone import get_referenced_files, process_includes


def test_get_referenced_files():
    fixture_path = Path(__file__).parent / "fixtures" / "default"
    assert get_referenced_files(
        fixture_path, (fixture_path / "zones" / "first.example.zone").read_text()
    ) == {
        fixture_path / "includes" / "example.zone",
        fixture_path / "includes" / "indirect.zone",
    }


def test_process_includes():
    fixture_path = Path(__file__).parent / "fixtures" / "default"
    assert (
        process_includes(
            fixture_path, (fixture_path / "zones" / "first.example.zone").read_text()
        )
        == """
@ IN TXT "first"
@ IN TXT "foo"
@ IN TXT "bar"
@ IN TXT "second"
""".lstrip()
    )
