from pathlib import Path

INCLUDE_MAGIC_WORD = "$INCLUDE"


def get_referenced_files(repo_path: Path, template: str) -> set[Path]:
    files = set()

    for line in template.splitlines():
        if not line.startswith(INCLUDE_MAGIC_WORD):
            continue
        data = [part for part in line.split(" ") if part != ""]

        file = repo_path / data[1]
        files.add(file)
        files.update(get_referenced_files(repo_path, file.read_text()))

    return files


def process_includes(repo_path: Path, zone: str) -> str:
    new_zone = ""
    for line in zone.splitlines():
        if not line.startswith(INCLUDE_MAGIC_WORD):
            new_zone += f"{line}\n"
            continue

        data = [part for part in line.split(" ") if part != ""]
        file = repo_path / data[1]

        new_zone += process_includes(repo_path, file.read_text())

    if not new_zone.endswith("\n"):
        new_zone += "\n"
    return new_zone
